/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.common.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;

public class SieveRecipeSerializer
extends ExNihiloRecipeSerializer<SieveRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_OAK.get());
    }

    public SieveRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack drop = buffer.m_130267_();
        ArrayList<MeshWithChance> rolls = new ArrayList<MeshWithChance>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            rolls.add(MeshWithChance.read(buffer));
        }
        boolean isWaterlogged = buffer.readBoolean();
        return new SieveRecipe(recipeId, input, drop, rolls, isWaterlogged);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull SieveRecipe recipe) {
        recipe.getInput().m_43923_(buffer);
        buffer.m_130055_(recipe.getDrop());
        buffer.writeInt(recipe.getRolls().size());
        for (MeshWithChance meshWithChance : recipe.getRolls()) {
            meshWithChance.write(buffer);
        }
        buffer.writeBoolean(recipe.isWaterlogged());
    }

    @Override
    protected SieveRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
        ItemStack drop = this.readOutput(json.get("result"));
        ArrayList<MeshWithChance> rolls = new ArrayList<MeshWithChance>();
        for (JsonElement element : json.get("rolls").getAsJsonArray()) {
            rolls.add(MeshWithChance.deserialize(element));
        }
        if (json.has("waterlogged")) {
            return new SieveRecipe(recipeId, input, drop, rolls, json.get("waterlogged").getAsBoolean());
        }
        return new SieveRecipe(recipeId, input, drop, rolls, false);
    }
}

